
%%
clear all;
clc;

[num, txt, raw]=xlsread('XFGsurface.csv');
% PPR 3-D & contour 

data=num;
clear num raw
nx=130; ny=74;

for i=1:nx
   xx(:,i)=data(i*ny-ny+1:i*ny,1); %core
   yy(:,i)=data(i*ny-ny+1:i*ny,2); %non core
   zz(:,i)=data(i*ny-ny+1:i*ny,3); %
end
xx=xx(:,1:5:130);
yy=yy(:,1:5:130);
zz=zz(:,1:5:130);
xx=xx(1:2:74,:);
yy=yy(1:2:74,:);
zz=zz(1:2:74,:);

figure1 = figure('PaperType','<custom>','PaperSize',[15 20]);
surf(xx,yy,zz)
colormap white % Ƕ
set(gca','FontSize',14)
xlabel('core CPI (%)')
ylabel('non-core CPI (%)')
axis tight
set(gca,'Position',[0.13 0.11 0.6981 0.815])
%colorbar('peer',gca,[0.8981 0.1115 0.02604 0.815]);
annotation(figure1,'textbox','String',{'FFR(%)'},'FontSize',14,...
    'FitHeightToText','off',...
    'EdgeColor','none',...
    'Position',[0.01897 0.499 0.08885 0.06814]);
view([-42.5 32]);
axis tight
set(gcf,'Position',[1, 1, 1024, 695])
set(gcf,'PaperPositionMode','auto')
print -dpng fig4.png
print -dmeta fig4.emf
print -depsc fig4.eps

figure
contour(xx,yy,zz,30)
colormap gray
set(gca','FontSize',14)
xlabel('core CPI (%)')
ylabel('non-core CPI (%)')
zlabel('FFR (%)')
print -dpng fig4-1.png
print -dmeta fig4-1.emf
print -depsc fig4-1.eps