% Taylor Rule for IRER model
clear all;
clc;

%% Load Data
load 00_010_0007_20080222_0005
I=[1:size(Rgdp,1)]';

p=GdpDef;
Y=Rgdp;

%% Estimate Long Term Real GDP Trend (Y*)
theta=fminsearch('Ystar_e1',[6000 2],[],[I Rgdp])
Ystar=theta(1)*(1+theta(2)/100).^I;
q=((1+2.2/100)^(1/4)-1)*100;
Ystar_1=theta(1)*(1+q/100).^I;

figure1 = figure('PaperType','<custom>','PaperSize',[15 20]);
Ti=[datenum(1970,3,31) datenum(1980,3,31) datenum(1990,3,31) datenum(2000,3,31)];
h=plot(T,[Rgdp Ystar Ystar_1],'k');
set(h(1),'linewidth',2)
set(h(2),'linewidth',1)
set(h(3),'linestyle','--','linewidth',1)
set(gca','FontSize',14,'box','off')
set(gca,'xtick',Ti,'xticklabel',{'Jan70','Jan80','Jan90','Jan00'})
xlim([min(T) max(T)+180])
ylim([0 max(Ystar)+1000])

leg=legend('Real GDP','growth trend','2.2 percent growth trend',2);
set(leg,'EdgeColor',[1 1 1],'box','off');
set(gcf,'Position',[1, 1, 1024, 695])

annotation(figure1,'textbox','String',{'(Billions)'},'FontSize',14,...
    'FitHeightToText','off',...
    'EdgeColor','none',...
    'Position',[0.06545 0.9367 0.1015 0.04029]);

set(gcf,'PaperPositionMode','auto')
print -dpng fig10.png
print -dmeta fig10.emf
print -depsc fig10.eps
%% p Taylor FFR
y = 100*(Y-Ystar)./Ystar;
Tr = p + 0.5*y + 0.5*(p-2) + 2; % Quarterly

% generate Tr(Quarterly) to Monthly data
mTr=repmat(Tr,1,3);
mTr=mTr';
mTr=mTr([1:1:size(mTr,1)*size(mTr,2)]);
mTr=mTr';
mTr(1)=[];  % Dec-1957
mTr(end-1:end)=[];  % generate Jan-2008, Feb-2008
%% Estimate Period (1984 ~ 1992) Real GDP Trend (Y*)
Ip=[find(T == datenum(1984,3,31));find(T == datenum(1992,12,31))];
Rgdp_1=Rgdp(Ip(1):Ip(2));
I_1=[1:size(Rgdp_1,1)]';

beta=fminsearch('Ystar_e1',[6000 2],[],[I_1 Rgdp_1])
Ystar_2=beta(1)*(1+beta(2)/100).^I_1;
q_1=((1+2.2/100)^(1/4)-1)*100;
Ystar_2_1=beta(1)*(1+q_1/100).^I_1;

figure1 = figure('PaperType','<custom>','PaperSize',[15 20]);
Ti=[datenum(1970,3,31) datenum(1980,3,31) datenum(1990,3,31) datenum(2000,3,31)];
h=plot(T(Ip(1):Ip(2)),[Rgdp_1 Ystar_2 Ystar_2_1],'k');
set(h(1),'linewidth',2)
set(h(2),'linewidth',1)
set(h(3),'linestyle','--','linewidth',1)
set(gca','FontSize',14,'box','off')
set(gca,'xtick',Ti,'xticklabel',{'Jan70','Jan80','Jan90','Jan00'})
xlim([T(Ip(1)) T(Ip(2))+180])
ylim([5500 max(Ystar_2)+250])

leg=legend('Real GDP','growth trend','2.2 percent growth trend',2);
set(leg,'EdgeColor',[1 1 1],'box','off');
set(gcf,'Position',[1, 1, 1024, 695])

annotation(figure1,'textbox','String',{'(Billions)'},'FontSize',14,...
    'FitHeightToText','off',...
    'EdgeColor','none',...
    'Position',[0.06545 0.9367 0.1015 0.04029]);

set(gcf,'PaperPositionMode','auto')
print -dpng fig10_1.png
print -dmeta fig10_1.emf
print -depsc fig10_1.eps
