library( lattice)

library( zoo)
library( lcp2)

## fixme path
exch.rates <-
  read.zoo("exch-rates.csv", format = "%F", header = TRUE)

log.returns <- diff( log( na.locf( exch.rates)))

interval.length <- c( 30, 38, 47, 59, 73, 92) ## 5,7,10,13,16,20,24,
#  c( 30,45,68,99) ## calc.interval.length(30, 1.5, 232)
rpower <- 0.5
test.level <- 0.2

critical.value <- calc.critical.values( data.width = ncol( exch.rates)
                                       , interval.length = interval.length
                                       , rpower = 0.5
                                       , test.level = test.level
                                       , num.rep = 30000)


## volatility estimates and homogeneous intervals
zz <- lcp2.filter( t( log.returns), interval.length, critical.value)$ae


############################## ACF things #############################
len.diff <- dim( log.returns)[1] - dim( zz)[3]
## standardized returns
std.returns <- t( sapply( 1:dim( zz)[3], function(t){
  backsolve( chol( zz[,,t]),
            ## begin change
            ##abs(
##                 as.vector( window( log.returns, start = len.diff + t,
##                        end = len.diff + t ))
            as.vector( log.returns[ len.diff + t,])
            )
            ## end changes
            ##)
}))
colnames( std.returns) <- colnames( exch.rates)

std.returns <- zoo( std.returns, order.by = tail( index( log.returns),
                                   nrow( std.returns)))

########## shamelessly stolen from the nlme package and adapted
##*## Plot method for ACF objects
plot.ACF <-
  function(x, alpha = 0, xlab = "Lag", ylab = "Autocorrelation",
           grid = FALSE, ylim, ...)
{
  object <- x
  ## ylim <- range(object$ACF)
  if (alpha) {
    assign("stdv",  qnorm(1-alpha/2)/sqrt(attr(object,"n.used")))
    stMax <- max(stdv)
    ylim <- c(min(c(-stMax, ylim[1])), max(c(ylim[2], stMax)))
  }
  assign("alpha", as.logical(alpha))
  assign("grid", grid)
  xyplot(ACF ~ lag | what, object, ylim = ylim,
         panel = function(x, y, ...) {
           x <- as.numeric(x)
           y <- as.numeric(y)
           ## optionally plot the grid
           if (grid) panel.grid()
           panel.xyplot(x, y, type = "h")
           ## this I do not want
           ## panel.abline(0, 0)
           if (alpha) {
             llines(x, stdv, lty = 3, lwd=.5)
             llines(x, -stdv, lty = 3, lwd=.5)
           }
         }, xlab = xlab, ylab = ylab, ...)
}

currencies <- c("AUD","NZD")

myplot <- function( acf, ...){
  dz <- dim( acf$lag)
  zzz <- data.frame( what = unlist( lapply( c( currencies[1],
                       paste( currencies[1], currencies[2], sep = " & "),
                       paste( currencies[2], currencies[1], sep = " & "),
                       currencies[2]),
                       function(x) rep(x, dz[1]))),
                    lag = abs( as.vector(acf$lag)), ## FIXME! UGLY!
                    ACF = as.vector(acf$acf))
  attributes(zzz) <- c( attributes(zzz), list(n.used = acf$n.used))
  plot.ACF( zzz, alpha=.05, index.cond = list( c(4,3,1,2)),
           ylim = c(-0.2, 0.2), layout = c(2,2))
}


trellis.device( device = "pdf",
               file = paste( "XFGacf", tolower(currencies[1]), "",
                 tolower( currencies[2]),
                 ".pdf", sep=""), height = 3.5, width = 7, color = FALSE)

mypar <- trellis.par.get("strip.background")
mypar$col <- "white"
trellis.par.set( "strip.background" = mypar)

print( myplot( acf( abs( coredata( log.returns[, currencies])), plot = FALSE)),
      split = c(1,1,2,1), more = TRUE)

print( myplot( acf( abs( coredata( std.returns[, currencies])), plot = FALSE)),
      split = c(2,1,2,1))
dev.off()
