## ACF plots of the absolute log returns and absolute standardized
##  log returns of GBP/USD
library( zoo)
library( lcplmsssa)

exch.rates <- read.zoo("exch-rates.csv", format = "%F", header = TRUE)

log.returns <- diff( log( na.locf( exch.rates[,"GBP"])))

vola.est <- 
  sqrt( filter.lcplmsssa( method = "LCP"
                         , model = "Volatility"
                         , interval.length = c( 5,7,10,13,16,20,24,30,38,47,59,73,92)
                         , aggregation.kernel = "Quadratic"
                         , rpower = 0.5
                         , test.level = 0.2
                         , data = log.returns^2 )$estimate)

pdf( file = "XFGacfgbplog.pdf", width = 6, height = 4)
par( mfrow = c(2,1), mar = c(1,4,1,1))
acf( abs( coredata( log.returns)), plot = TRUE, xaxt = "n",
    ylim = c( -0.1, 0.2), ylab = "Abs. log returns")
par( mar = c(4,4,1,1))
acf( abs( coredata( tail( log.returns, length( vola.est)) / vola.est)),
    plot = TRUE, ylim=c( -0.1, 0.2), ylab = "Abs. std. log returns", main = "")
dev.off()
