library(quantreg)
library(coda)

para.dax=scan("../result/example/(DAX) sv_vol_para.txt",skip=2)

iter=length(para.dax)/3;

para.dax=matrix(para.dax,iter, 3, byrow=T)
para.dax[,1]=para.dax[,1]/(1-para.dax[,2]);

summary.dax=summary(mcmc(para.dax))

table.sv.dax <- rbind(
     c(summary.dax$statistics[1,1], summary.dax$statistics[1,2], summary.dax$statistics[1,4], summary.dax$quantiles[1,1], summary.dax$quantiles[1,5]),
     c(summary.dax$statistics[2,1], summary.dax$statistics[2,2], summary.dax$statistics[2,4], summary.dax$quantiles[2,1], summary.dax$quantiles[2,5]),
     c(summary.dax$statistics[3,1], summary.dax$statistics[3,2], summary.dax$statistics[3,4], summary.dax$quantiles[3,1], summary.dax$quantiles[3,5])
     )
colnames(table.sv.dax) <- c('Mean', 'SD', 'TS-SE', '95 CI lower', '95 CI upper')
rownames(table.sv.dax) <- c('mu', 'phi', 'sigma')
#latex.table(table.dax, file="summary.dax", rowlabel="", caption="")


table.sv.dax

geweke.diag(para.dax)
heidel.diag(para.dax)
