####################################################################
## estimate volatility, compute standardized returns and demonstrate
##  that the ACF of a non-linear function of standardized returns
##  fades quickly (opposed to a non-linear function of log returns)

library( zoo)
library( lcp2)

## fixme path
exch.rates <-
  read.zoo("exch-rates.csv", format = "%F", header = TRUE)

log.returns <- diff( log( na.locf( exch.rates)))

interval.length <- c( 30, 38, 47, 59, 73, 92) ## 5,7,10,13,16,20,24,
#  c( 30,45,68,99) ## calc.interval.length(30, 1.5, 232)
rpower <- 0.5
test.level <- 0.2

critical.value <- calc.critical.values( data.width = ncol( exch.rates)
                                       , interval.length = interval.length
                                       , rpower = 0.5
                                       , test.level = test.level
                                       , num.rep = 30000)


## volatility estimates and homogeneous intervals
zz <- lcp2.filter( t( log.returns), interval.length, critical.value)$ae

##################################################
covar <- sapply( 1:ncol( exch.rates), function(i) zz[i,i,])
colnames( covar) <- colnames( exch.rates)
annu.vola <- zoo( sqrt( 250 * covar),
                 order.by = tail( index( exch.rates), nrow( covar)))
pdf( "XFGcovmatexch.pdf", width = 7, height = 4)
plot( annu.vola[, c( "CAD", "DKR", "JPY", "AUD")], main=""
     ## , screens = c(1,1, 2,2)
     , xlab = "Year"
     )
dev.off()
