### for the book "Computational finance"
## plot the exchange rate and log returns of GBP to USD in 1990-1999
## source: Federal Reserve
library( zoo)

exch.rates <- read.zoo("exch-rates.csv", format = "%F", header = TRUE)

pdf( file = "XFGgbpratesreturns.pdf", width = 6, height = 4,
    title = "Exchange rate and log returns of the GBP to USD")
opar <- par( mar = c(1,4,1,1))
plot( local({
  zz <- cbind( exch.rates[,"GBP"], diff( log( na.locf( exch.rates[,"GBP"]))))
  colnames( zz) <- c("Spot exchange rate", "Log returns")
  zz
}), main = "", xlab="")
dev.off()
