### for the paper "Computational finance"
## plot volatility estimates for the GBP/USD exchange rate
library( zoo)
library( lcplmsssa)

exch.rates <- read.zoo("exch-rates.csv", format = "%F", header = TRUE)

pdf( file = "XFGgbpvolaest.pdf",
    title = "Volatility estimates obtained by different methods",
    height = 4, width = 6)
plot( local({
  methods <- c("LCP","LMS","SSA")
  estimation.results <-
    do.call( cbind,
            lapply( methods, function( method){
              filter.lcplmsssa( method = method
                               , model = "Volatility"
                               , interval.length = c( 5,7,10,13,16,20,24,30,38,47,59,73,92)
                               , aggregation.kernel = "Quadratic"
                               , rpower = 0.5
                               , test.level = 0.2
                               , data = diff( log( na.locf( exch.rates[,"GBP"])))^2 )$estimate
            }))
  colnames( estimation.results) <- methods
  zoo( sqrt( estimation.results),
      order.by = tail( index( exch.rates), nrow( estimation.results)))
})
     , xlab = "", main="", oma = c(6,0,1,0))
dev.off()
