library(quantreg)
library(coda)

para.dax=scan("../result/example/(DAX) sv_vol_para.txt",skip=2)
para.dowjones=scan("../result/example/(Dow Jones) sv_vol_para.txt",skip=2)
para.gbpusd=scan("../result/example/(GBP-USD) sv_vol_para.txt",skip=2)

iter=length(para.dax)/3;

para.dax=matrix(para.dax,iter, 3, byrow=T)
para.dax[,1]=para.dax[,1]/(1-para.dax[,2]);
para.dowjones=matrix(para.dowjones,iter, 3, byrow=T)
para.dowjones[,1]=para.dowjones[,1]/(1-para.dowjones[,2]);
para.gbpusd=matrix(para.gbpusd,iter, 3, byrow=T)
para.gbpusd[,1]=para.gbpusd[,1]/(1-para.gbpusd[,2]);

summary.dax=summary(mcmc(para.dax))
summary.dowjones=summary(mcmc(para.dowjones))
summary.gbpusd=summary(mcmc(para.gbpusd))

table.sv.dax <- rbind(
     c(summary.dax$statistics[1,1], summary.dax$statistics[1,2], summary.dax$statistics[1,4], summary.dax$quantiles[1,1], summary.dax$quantiles[1,5]),
     c(summary.dax$statistics[2,1], summary.dax$statistics[2,2], summary.dax$statistics[2,4], summary.dax$quantiles[2,1], summary.dax$quantiles[2,5]),
     c(summary.dax$statistics[3,1], summary.dax$statistics[3,2], summary.dax$statistics[3,4], summary.dax$quantiles[3,1], summary.dax$quantiles[3,5])
     )
colnames(table.sv.dax) <- c('Mean', 'SD', 'TS-SE', '95 CI lower', '95 CI upper')
rownames(table.sv.dax) <- c('mu', 'phi', 'sigma')
#latex.table(table.dax, file="summary.dax", rowlabel="", caption="")

table.sv.dowjones <- rbind(
     c(summary.dowjones$statistics[1,1], summary.dowjones$statistics[1,2], summary.dowjones$statistics[1,4], summary.dowjones$quantiles[1,1], summary.dowjones$quantiles[1,5]),
     c(summary.dowjones$statistics[2,1], summary.dowjones$statistics[2,2], summary.dowjones$statistics[2,4], summary.dowjones$quantiles[2,1], summary.dowjones$quantiles[2,5]),
     c(summary.dowjones$statistics[3,1], summary.dowjones$statistics[3,2], summary.dowjones$statistics[3,4], summary.dowjones$quantiles[3,1], summary.dowjones$quantiles[3,5])
     )
colnames(table.sv.dowjones) <- c('Mean', 'SD', 'TS-SE', '95 CI lower', '95 CI upper')
rownames(table.sv.dowjones) <- c('mu', 'phi', 'sigma')

table.sv.gbpusd <- rbind(
     c(summary.gbpusd$statistics[1,1], summary.gbpusd$statistics[1,2], summary.gbpusd$statistics[1,4], summary.gbpusd$quantiles[1,1], summary.gbpusd$quantiles[1,5]),
     c(summary.gbpusd$statistics[2,1], summary.gbpusd$statistics[2,2], summary.gbpusd$statistics[2,4], summary.gbpusd$quantiles[2,1], summary.gbpusd$quantiles[2,5]),
     c(summary.gbpusd$statistics[3,1], summary.gbpusd$statistics[3,2], summary.gbpusd$statistics[3,4], summary.gbpusd$quantiles[3,1], summary.gbpusd$quantiles[3,5])
     )
colnames(table.sv.gbpusd) <- c('Mean', 'SD', 'TS-SE', '95 CI lower', '95 CI upper')
rownames(table.sv.gbpusd) <- c('mu', 'phi', 'sigma')

table.sv.dax
table.sv.dowjones
table.sv.gbpusd
