coreCPIcpiffr.dir = "D:\\IRER\\FFR\\sƧ\\XFGsurface2.txt"     #<==== change where XFGsurface2.txt is stored
savedir = "D:\\IRER\\FFR\\"
period=0.1              # the width of x(core) & y(noncore) 

##############################################################
############   estimation by linear regression    ############ 
##############################################################
# save FFR estimation by linear regression
data = read.table(coreCPIcpiffr.dir)
ffr = data$V3
core = data$V1
CPI = data$V2
noncore=CPI-core
linear.reg = lm(ffr ~ core + noncore)
estimation = predict(linear.reg)

# save estimated coefficient 
write.table(linear.reg$coefficients, sprintf("%s coefficient estimated by linear regression.txt", savedir)
            , col.names=F, quote=F )  

z = linear.reg$coefficients["core"]*core + linear.reg$coefficients["noncore"]*noncore 
# save regressive estimations & z=alpha1*core + alpha2*noncore 
write.csv(data.frame(z=z, estimation=estimation)
          , sprintf("%s z and estimations by linear regression.csv", savedir), row.names=F)  

######## interpolation of regressive estimations   
approxX = seq(min(core), max(core), by=period)
approxY = seq(min(noncore), max(noncore), by=period)
approxZ = cbind(rep(approxX, each=length(approxY)), rep(approxY, length(approxX))) %*% linear.reg$coefficients[c("core", "noncore")]
approxReg = rep(NA, length(approxZ))

for(i in 1:length(approxZ)) {      # computing approximate values of regressive estimations 
   if(approxZ[i] > max(z) | approxZ[i] < min(z)) next

   m1 = which(approxZ[i] - z >= 0)
   m1 = m1[which.max(approxZ[i] - z[m1] )]

   m2 = which(approxZ[i] - z <= 0)
   m2 = m2[which.min(z[m2] - approxZ[i])]
   
   if(z[m1] == z[m2]) M = 0  else  M = (estimation[m1] - estimation[m2])/(z[m1] - z[m2])    # M is the slope of the approximation line
   b = estimation[m1] - M*z[m1]                                                             # b is the intercept of the approximation line
   approxReg[i] = M*approxZ[i] + b
}

write.csv(data.frame(approxCore=rep(approxX, each=length(approxY)), approxNoncore=rep(approxY, length(approxX)), estimation=approxReg)
          , sprintf("%s estimations by linear regression and interpolation.csv", savedir), row.names=F)      
            


