
library(coda)

#SVt
para.dax=scan("../result/example/(DAX) svt_vol_para.txt",skip=2)

n=3

iter=length(para.dax)/n;

para.dax=matrix(para.dax,iter, n, byrow=T)
para.dax[,1]=para.dax[,1]/(1-para.dax[,2]);

nu.dax=scan("../result/example/(DAX) svt_nu.txt",skip=2)
para.dax=cbind(para.dax, nu.dax)
summary.dax=summary(mcmc(para.dax))
table.svt.dax <- rbind(
     c(summary.dax$statistics[1,1], summary.dax$statistics[1,2], summary.dax$statistics[1,4], summary.dax$quantiles[1,1], summary.dax$quantiles[1,5]),
     c(summary.dax$statistics[2,1], summary.dax$statistics[2,2], summary.dax$statistics[2,4], summary.dax$quantiles[2,1], summary.dax$quantiles[2,5]),
     c(summary.dax$statistics[3,1], summary.dax$statistics[3,2], summary.dax$statistics[3,4], summary.dax$quantiles[3,1], summary.dax$quantiles[3,5]),
     c(summary.dax$statistics[4,1], summary.dax$statistics[4,2], summary.dax$statistics[4,4], summary.dax$quantiles[4,1], summary.dax$quantiles[4,5])
     )
colnames(table.svt.dax) <- c('Mean', 'SD', 'TS-SE', '95 CI lower', '95 CI upper')
rownames(table.svt.dax) <- c('mu', 'phi', 'sigma', 'v')

table.svt.dax

# SVJ
h=scan("../result/example/(DAX) svj_vol_para.txt",skip=2)
q=scan("../result/example/(DAX) svj_q_para.txt",skip=2)
k=scan("../result/example/(DAX) svj_k_para.txt",skip=2)

