## value at risk

library( zoo)
library( lcplmsssa)

interval.length <- c( 5,7,10,13,16,20,24,30,38,47,59,73,92)

rpower <- 0.5
test.level <- 0.2

exch.rates <-
  read.zoo( "exch-rates.csv", format = "%F", header = TRUE)

methods <- c("LCP", "LMS", "SSA")
currencies <- c("AUD") ## colnames( exch.rates)
var.levels <- c(.01, .05)
horizons <- c(1, 5, 10)
inno.distr <- c("Gaussian", "Student5", "Empirical")

zz <- 
do.call( rbind, lapply( currencies, function( currency){
  log.returns <- diff( log( na.locf( exch.rates[ , currency])))
  do.call( rbind, lapply( methods, function( method){
    vari.forecast <- local( {
      zz <- filter.lcplmsssa( method = method
                                      , model = "Volatility"
                                      , interval.length = interval.length
                                      , aggregation.kernel = "Quadratic"
                                      , rpower = rpower
                                      , test.level = test.level
                                      , data = log.returns^2 )$estimate
      zoo( zz, order.by = tail( index( log.returns), length(zz)))
    })
    do.call( rbind, lapply( horizons, function( horizon){
      aggregated.returns <- rollapply( log.returns, width = horizon, FUN = sum)
      do.call( rbind, lapply( inno.distr, function( i.d){
        
        ## function returning the value at risk
        var.fun <-
          switch( i.d,
                 Gaussian = function( var.level){
                   qnorm( p = var.level, sd = sqrt( horizon * vari.forecast))
                 },
                 Student5 = local({
                   student.df <- 5
                   ## factor to make the variance unit
                   student.scale.factor <- sqrt( (student.df - 2) / student.df)
                   ## caching ff in the closure
                   ff <- sqrt( vari.forecast)
                   function( var.level){
                     quantile( replicate( 1e4, ff * student.scale.factor * sum( rt( n = horizon, df = student.df))), probs = var.level)
                   }
                 }),
                 Empirical = local({
                   ff <- sqrt( vari.forecast)
                   ## innovations
                   inno <- log.returns / ff
                   function( var.level){
                     zz <- replicate( 1e3, ff * sum( sample( inno, horizon,
                                                            replace = TRUE)))
                     zoo( apply( zz, MARGIN = 1, function(x){
                       quantile( x = x, probs = var.level)
                     }), order.by = index( ff))
                   }
                 }))
        
        ## compute quantiles, compare with aggregated returns
        data.frame( currency = currency,
                   method = method,
                   inno.distr = i.d,
                   var.level = var.levels,
                   horizon = horizon,
                   perc.overshoo = sapply( var.levels, function( var.level){
                     zz <- var.fun( var.level) - aggregated.returns
                     ## this should not be zoo anymore
                     unclass( length( which( zz > 0 ))/ length(zz) * 100)
                   }))
      }) )
    }) )
  }) )
}) )

#################### plotting ####################
zz$var.level <- paste( zz$var.level * 100, "% VaR", sep = "")
zz$horizon <- sapply( zz$horizon, function(x) paste( x, ifelse( x==1, "step"
                                                               , "steps")))
library( lattice)

trellis.device( device = "pdf", file = sprintf("XFGvar%s.pdf", currencies[1]),
               color = FALSE, ## why are books not colourful?
               height = 4, width = 8 )
## get rid of the grey background in headers
mypar <- trellis.par.get("strip.background")
mypar$col <- "white"
trellis.par.set( "strip.background" = mypar)
print( dotplot( perc.overshoo ~ inno.distr | horizon + var.level
               , subset( zz, subset = currency == currencies[1])
               , groups = method, auto.key = TRUE
               , origin = 0
               , index.cond = list( c(2,3,1), c(1,2))
               ## , main = my.currency
               , reference = TRUE, abbreviate = TRUE
               , ylab = "Percentage of overshooting"
               , scales = list( y = list(relation = "free"))
               , ylim = c( rep( list( c(0, 2.5)), 3),
                   rep( list( c(0, 7)), 3))))
dev.off()
