proc(IVS, gamma2, nu2) = IVSurface(VarEst)

; fix bandwidth
  huse = getglobal("huse")
 
  if (exist("VarEst")==0) ; just estimate the function
;  xmin  = #(0.85, 0.047222)
;  xmax  = #(1.15, 0.047222) 
    xmin  = #(0.90, 0.047222)
    xmax  = #(1.08, 0.047222) 

    N = #(50,1) 
    xstep = (xmax - xmin)./N 
  
    IVS       = matrix(prod(N),3)
    IVS[,1:2] = grid(xmin, xstep, N )
  else ; estimate the variance 
    data = getglobal("dataday")  
; to estimate variance it is good to reduce the grid 
;data = paf(data, data[,7]>0.89)
;data = paf(data, data[,7]<1.12)
    data = paf(data, data[,7]>0.91)
    data = paf(data, data[,7]<1.07)

;dim(data)
;data = paf(data, uniform(rows(data))<0.01)
    dim(data)
    data = data[,1:9]
    data[,9] = 0*data[,9] 

    IVS = data[,7]~data[,4]~matrix(rows(data))
  endif

  i = 1
  I = rows(IVS)
  I
  while (i<=I)
    x = trans(IVS[i, 1:2])
    h = #(huse,1)
    
    putglobal("h")
    putglobal("x")

    sol = nmgolden("LSKernIVSEst",0.01,0.2,0.85,1e-2)    

    IVS[i,3] = sol.xmin
    i~sol.xmin
    if (exist("VarEst")!=0) ; if a variance is to be estimated
      data[i,8] = sol.xmin
    endif   
    i = i+1
  endo
 
  gamma2 = 0
  nu2    = 0
  if (exist("VarEst")!=0) ; if a variance is to be estimated 
    dataZZ = data
    putglobal("dataZZ")
    {gamma2, nu2} = VarEstLSKS(data)
  endif
endp


proc(p)=BlackScholes(S, K, r, sigma, tau, task, d)
  if (exist(d)==0)
    d = 0*matrix(rows(S))   
  endif
  error ( rows(S)!=rows(K)||rows(S)!=rows(r)||rows(S)!=rows(sigma)||rows(S)!=rows(tau)||rows(S)!=rows(task), "Vectors must have the same length"  )

  error((S<=0),"BlackScholes: price needs to be larger than 0")
  error((K<=0),"BlackScholes: strike price needs to be larger than 0")
  error(((task!=0)&&(task!=1)),"BlackScholes: task needs to be either 1 or 0")
  error(((r<0)||(r>=1)),"BlackScholes: interest rate needs to be between 0 and 1")
  error(((d<0)||(d>=1)),"BlackScholes: dividends need to be between 0 and 1")
  error((sigma<=0),"BlackScholes: volatility needs to be larger than 0")
  error((tau<=0),"BlackScholes: time to expiration needs to be larger than 0")

  b = r-d
  y = (log(S./K)+(b-(sigma^2)/2).*tau)./(sigma.*sqrt(tau))
; first part computes  Call option, second the put:
  p = (exp((b-r).*tau) .*S .*cdfn(y+sigma.*sqrt(tau)) - K .*exp(-r.*tau) .*cdfn(y) ).*(task==1) + (K.*exp(-r.*tau) .* cdfn(-y) - exp((b-r).*tau).*S.* cdfn(-y-sigma.*sqrt(tau)) ).*(task==0)
  if(p<0)
    p=0
  endif	
endp


proc (gamma2, nu2)=VarEstLSKS(data)
  S      = data[,1]
  K      = data[,2]
  r      = data[,3]
  tau    = data[,4]
  task   = data[,6]
  kappa  = data[,7]
  sigmahat = data[,8]
  oprice = data[,5]
  
; compute A, B, D
; we do not need to adjust for moneyness as the spot cancels out:
  A = oprice - BlackScholes(S, K, r, sigmahat, tau, task)

  {B, D} = BSVegaVolga(S, K, r, sigmahat, tau, task)


  gamma2 = ( mean(-B^2 + A.*D) )^2
  nu2    =   mean( (A^2).*(B^2) ) * 25/49 

; \int\int K(u)^2 K(v)^2 dudv = 25/49 for quartic Kernel

endp

proc(vega, volga) = BSVegaVolga(S, K, r, sigma, tau, task, d)
  if (exist(d)==0)
    d = 0*matrix(rows(S))   
  endif
  error ( rows(S)!=rows(K)||rows(S)!=rows(r)||rows(S)!=rows(sigma)||rows(S)!=rows(tau)||rows(S)!=rows(task), "Vectors must have the same length"  )

  error((S<=0),"BlackScholes: price needs to be larger than 0")
  error((K<=0),"BlackScholes: strike price needs to be larger than 0")
  error(((task!=0)&&(task!=1)),"BlackScholes: task needs to be either 1 or 0")
  error(((r<0)||(r>=1)),"BlackScholes: interest rate needs to be between 0 and 1")
  error(((d<0)||(d>=1)),"BlackScholes: dividends need to be between 0 and 1")
  error((sigma<=0),"BlackScholes: volatility needs to be larger than 0")
  error((tau<=0),"BlackScholes: time to expiration needs to be larger than 0")
 
  b = r-d
  d1 = ( log(S./K)+(b+(sigma^2)/2).*tau )./(sigma.*sqrt(tau))
  d2 = (log(S./K)+(b-(sigma^2)/2).*tau)./(sigma.*sqrt(tau))
  vega = S.*sqrt(tau).*pdfn(d1).*exp(-d.*tau)
  volga1 = S.*exp(-d.*tau).*tau.*pdfn(d1).*( (d1^2)./(sigma.*sqrt(tau))-d1 )
  volga = S.*exp(-d.*tau).*sqrt(tau).*pdfn(d1).*( d1.*d2./sigma )
endp

proc(Q) = LSKernIVSEst(sigma)
  sigmaB = sigma
; (S, K, r, sigma, tau, task) 

  data = getglobal("dataday")
  h    = getglobal("h")
  x    = getglobal("x")

  S      = data[,1]
  K      = data[,2]
  r      = data[,3]
  tau    = data[,4]
  task   = data[,6]
  kappa  = data[,7]
  oprice = data[,5]

; blow sigma up to fit with other data 
  sigma  = sigma*matrix(rows(data))

; umoney and utau
  u = ( (kappa-x[1])/h[1] )
  Kern = 0.9375.*(abs(u).<1).*(1-u^2)^2

  resid =  oprice./S - BlackScholes(S, K, r, sigma, tau, task)./S 
  
  Q = sum( (resid^2).*Kern )
endp 

library("kernel") library("nummath") library("finance")
setenv("statusmessage","off")

pf = "D:\projects\VolaEstimatorDeneb\dataXFG\"

; to use please choose data source and bandwidth
;dataday = read(pf+"FebruaryData.dat")
dataday = read(pf+"JanuaryData.dat")

; choose bandwidth
  hfeb = 0.017
  hjan = 0.025

; huse is the bandwidth finally used  
  huse = hjan

{Smile, gamma2, nu2}= IVSurface()

Smile = setmask(Smile[,1]~Smile[,3],"line")

dataUnCorr = dataday

xUnCorr = dataUnCorr[,7]~dataUnCorr[,8]
setmaskp(xUnCorr, 1,3,3)
opPrices = dataUnCorr[,7]~(dataUnCorr[,5]./dataUnCorr[,1])
setmaskp(opPrices, 0,3,3)
setsize(500,500)
plotdisplay = createdisplay(1,1)
plotdisplay2 = createdisplay(1,1)

; these numbers are precomputed as their computation is time consuming
gamma2 = 29176326722.4258  
nu2    = 1482489.0485 

; estimate densities on the grid of the Smile

hdens = denrot(dataday[,7])
fh    = denxest(dataday[,7], hdens, "qua", Smile[,1])
sigma2band = nu2/(gamma2 .* fh[,2])
n = rows(dataday)
h = 0.025
confup = Smile[,1]~( Smile[,2]+ 1.96*sqrt(n*h)*sqrt(sigma2band) )
conflo = Smile[,1]~( Smile[,2]- 1.96*sqrt(n*h)*sqrt(sigma2band) )

setmaskp(confup ,0,0,0)
setmaskl(confup, trans(1:rows(confup)), 0, 3,2)
setmaskp(conflo ,0,0,0)
setmaskl(conflo, trans(1:rows(conflo)), 0, 3,2)

show(plotdisplay2,1,1, Smile, xUnCorr, confup,conflo)
show(plotdisplay,1,1, opPrices)
setgopt(plotdisplay2,1,1,"border",0,"yvalue",0|1, "xlabel","Moneyness","ylabel"," ", "xvalue", 0|1,"title", "Smile" )
setgopt(plotdisplay,1,1,"border",0,"yvalue",0|1, "xlabel","Moneyness","ylabel"," ", "xvalue", 0|1,"title","Put and call prices per moneyness")




