proc()=XFGseries()
; ----------------------------------------------------------------------
;  EBook         XFG        
; ----------------------------------------------------------------------
;  Macro         XFGseries
; ----------------------------------------------------------------------
;  Description   Display spread curves
; ----------------------------------------------------------------------
;  Usage         XFGseries()
; ----------------------------------------------------------------------
;  Author        Germar Knoechlein, 20010106
; ----------------------------------------------------------------------

  USTF=read("XFGUSTF")
  INAAA=read("XFGINAAA")
  SINAAA=INAAA[,4:12]-USTF[,4:12]

  xmin=60
  xmax=rows(SINAAA)
  x=(xmin:xmax)

  setsize(700,333)
  d2=createdisplay(2,3)

  z1 = setmask(x~SINAAA[xmin:xmax,3], "line", "black")
  show(d2,1,1,z1)
  setgopt(d2,1,1, "title", "1Y-Spread (AAA)")
  setgopt(d2,1,1, "xlabel", "Day", "ylabel", "Spread in %") 

  z1 = setmask(x~SINAAA[xmin:xmax,4], "line", "black")
  show(d2,2,1,z1)
  setgopt(d2,2,1, "title", "2Y-Spread (AAA)")
  setgopt(d2,2,1, "xlabel", "Day", "ylabel", "Spread in %") 

  z1 = setmask(x~SINAAA[xmin:xmax,5], "line", "black")
  show(d2,1,2,z1)
  setgopt(d2,1,2, "title", "3Y-Spread (AAA)")
  setgopt(d2,1,2, "xlabel", "Day", "ylabel", "Spread in %") 

  z1 = setmask(x~SINAAA[xmin:xmax,7], "line", "black")
  show(d2,2,2,z1)
  setgopt(d2,2,2, "title", "5Y-Spread (AAA)")
  setgopt(d2,2,2, "xlabel", "Day", "ylabel", "Spread in %") 

  z1 = setmask(x~SINAAA[xmin:xmax,8], "line", "black")
  show(d2,1,3,z1)
  setgopt(d2,1,3, "title", "7Y-Spread (AAA)")
  setgopt(d2,1,3, "xlabel", "Day", "ylabel", "Spread in %") 

  z1 = setmask(x~SINAAA[xmin:xmax,9], "line", "black")
  show(d2,2,3,z1)
  setgopt(d2,2,3, "title", "10Y-Spread (AAA)")
  setgopt(d2,2,3, "xlabel", "Day", "ylabel", "Spread in %") 
endp

library("plot")
XFGseries()

