proc(VaRS)=XFGtimeseries2(PLD,options,N)
; ----------------------------------------------------------------------
;  EBook         XFG        
; ----------------------------------------------------------------------
;  See_also      VaRtimeplot VaRqqplot
; ----------------------------------------------------------------------
;  Macro         XFGtimeseries2
; ----------------------------------------------------------------------
;  Description   Displays VaR time series
; ----------------------------------------------------------------------
;  Usage         VaRS = XFGtimeseries2(PLD,options,N)
; ----------------------------------------------------------------------
;  Author        Germar Knoechlein, 20010106
; ----------------------------------------------------------------------
  n=rows(PLD)
  t=1
  VaRS=matrix(n,2)
  while (t<=n)
    Vinput=(PLD[t,])'|1|1
    temp=VaRest(Vinput,"EDF",options)
    VaRS[t,]=temp[1,]
    t=t+1
  endo
endp

library("VaR")
PL=read("XFGPL3")
MMPL=read("XFGMMPL3")
N=cols(PL)

opt=VaRopt("h",N,"color","red")
VaR=XFGtimeseries2(PL,opt)
VaRtimeplot(matrix(N,1)|MMPL,VaR,opt)
VaRqqplot(matrix(N,1)|MMPL,VaR,opt)

