proc()=XFGtreasury()
; ----------------------------------------------------------------------
;  EBook         XFG        
; ----------------------------------------------------------------------
;  Macro         XFGtreasury
; ----------------------------------------------------------------------
;  Description   Plots Treasury Yields
; ----------------------------------------------------------------------
;  Usage         XFGtreasury()
; ----------------------------------------------------------------------
;  Author        Germar Knoechlein, 20010106
; ----------------------------------------------------------------------

  USTF=read("XFGUSTF")

  xmin=1
  xmax=rows(USTF)
  x=(xmin:xmax)

  setsize(700,500)
  d1=createdisplay(1,1)

  z1 = setmask(x~USTF[xmin:xmax,4], "line", "black")
  z2 = setmask(x~USTF[xmin:xmax,6], "line", "green")
  z3 = setmask(x~USTF[xmin:xmax,7], "line", "blue")
  z4 = setmask(x~USTF[xmin:xmax,10], "line", "red")
  z5 = setmask(x~USTF[xmin:xmax,12], "line", "magenta")

  show(d1,1,1,z1,z2,z3,z4,z5)
  setgopt(d1,1,1, "title", "US Treasury Yields (3M, 1Y, 2Y, 5Y, 10Y)")
  setgopt(d1,1,1, "xlabel", "Day", "ylabel", "Yield in %", "xvalue",0|1) 
  setgopt(d1,1,1,"yoffset",8|13,"xoffset",10|3)
endp

library("plot")
XFGtreasury()

