proc()=XFGyields()
; ----------------------------------------------------------------------
;  EBook         XFG        
; ----------------------------------------------------------------------
;  Macro         XFGyields
; ----------------------------------------------------------------------
;  Description   Displays averaged yields
; ----------------------------------------------------------------------
;  Usage         XFGyields()
; ----------------------------------------------------------------------
;  Author        Germar Knoechlein, 20010106
; ----------------------------------------------------------------------

  USTF=read("XFGUSTF")
  INAAA=read("XFGINAAA")

  xmin=1
  xmax=rows(USTF)

  x=0.25|0.5|1|2|3|4|5|7|10

  y=mean(USTF[xmin:xmax,4:12])

  y=y|mean(INAAA[xmin:xmax,4:12])
  y=y'

  z1=setmask(x~y[,1],"black")
  z2=setmask(x~y[,2],"green")

  dmean=createdisplay(1,1)
  show(dmean,1,1,z1,z2)
  setgopt(dmean,1,1, "title", "Yields for Different Risk Levels")
  setgopt(dmean,1,1, "xlabel", "Time to Maturity in Years", "ylabel", "Average Yield in %") 
endp

library("plot")
XFGyields()

