% Dft spectra - examples
% s3s10_1.m * mw * 11/17/2007
%% Signals
N = 20;    % DFT length
n = 0:N-1; % normalized time
x1 = zeros(1,N); x1(11) = 1; % signal 1
x2 = ones(1,N);              % signal 2
x3 = sin((2*pi/5)*n);        % signal 3
%% DFT spectra
X1 = fft(x1);
X2 = fft(x2);
X3 = fft(x3);
%% Graphics
figure('Name','DFT Spectra','NumberTitle','off');
subplot(3,3,1), stem(n,x1,'filled','MarkerSize',5);
axis([0 N-1 -1 1]); grid;
ylabel('x_1[n] \rightarrow')
subplot(3,3,2), stem(n,real(X1),'filled','MarkerSize',5); grid
axis([0 N-1 -1 1]);
ylabel('Re(X_1[k]) \rightarrow')
subplot(3,3,3), stem(n,imag(X1),'filled','MarkerSize',5); grid
axis([0 N-1 -1 1]);
ylabel('Im(X_1[k]) \rightarrow')
subplot(3,3,4), stem(n,x2,'filled','MarkerSize',5);
axis([0 N-1 -1 1]); grid;
ylabel('x_2[n] \rightarrow')
subplot(3,3,5), stem(n,real(X2),'filled','MarkerSize',5); grid
axis([0 N-1 0 20]);
ylabel('Re(X_2[k]) \rightarrow')
subplot(3,3,6), stem(n,imag(X2),'filled','MarkerSize',5); grid
axis([0 N-1 -1 1]);
ylabel('Im(X_2[k]) \rightarrow')
subplot(3,3,7), stem(n,x3,'filled','MarkerSize',5);
axis([0 N-1 -1 1]); grid;
ylabel('x_3[n] \rightarrow'); xlabel('n \rightarrow');
subplot(3,3,8), stem(n,real(X3),'filled','MarkerSize',5); grid
axis([0 N-1 -1 1]);
ylabel('Re(X_3[k]) \rightarrow'); xlabel('k \rightarrow');
subplot(3,3,9), stem(n,imag(X3),'filled','MarkerSize',5); grid
axis([0 N-1 -10 10]);
ylabel('Im(X_3[k]) \rightarrow'); xlabel('k \rightarrow'); 