% Circular convolution
% s3s10_2.m * mw * 11/15/2007
N = 8;                        % period
x1 = [1,-1,1,-1,zeros(1,4)] ; % signal 1
x2 = [1,1,-1,-1,zeros(1,4)];  % signal 2
% Circular convolution
x3 = zeros(1,N);
for n =1:N
  for k =1:N
      x3(n) = x3(n) + x1(k)*x2(mod(n-k,N)+1);
  end
end
% Graphics
figure('Name','Cyclic Convolution','NumberTitle','off');
subplot(3,1,1), stem(0:N-1,x1,'filled','MarkerSize',5);
axis([0 N-1 -1 1]); grid;
ylabel('x_1[n] \rightarrow')
subplot(3,1,2), stem(0:N-1,x2,'filled','MarkerSize',5); grid
axis([0 N-1 -1 1]);
ylabel('x_2[n] \rightarrow')
subplot(3,1,3), stem(0:N-1,x3,'filled','MarkerSize',5); grid
axis([0 N-1 -1 1]);
ylabel('x_3[n] \rightarrow')
xlabel('n \rightarrow')