% Bandpass filtering with DFT
% s3s10_3.m * mw * 11/17/2007
%% Noise signal
N = 128;        % DFT length
x = randn(1,N); % noise signal
X = fft(x,N);   % dft spectrum of noise signal
%% Bandpass filter
H = zeros(0,N);
for k=1:N
  wk = (2*pi/N)*(k-1);
  if wk > 3*pi/8 & wk < 5*pi/8 % passband
    H(k) = 1;
  elseif wk > 11*pi/8 & wk< 13*pi/8 % passband
    H(k) = 1;
  else % stopband
    H(k) = 0;    
  end
end
Y = X.*H;   % filtering in frequency domain
y = real(ifft(Y,N));
%% Graphics
figure('Name','Bandpass Filtering with DFT','NumberTitle','off');
subplot(4,1,1), stem(0:N-1,x,'filled','MarkerSize',5);
axis([0 N-1 -4 4]); grid;
ylabel('x[n] \rightarrow')
subplot(4,1,2), stem(0:N-1,y,'filled','MarkerSize',5); grid
axis([0 N-1 -2 2]);
ylabel('y[n] \rightarrow')
subplot(4,1,3), stem(0:N-1,abs(X),'filled','MarkerSize',5); grid
axis([0 N-1 0 30]);
ylabel('|X[k]| \rightarrow')
subplot(4,1,4), stem(0:N-1,abs(Y),'filled','MarkerSize',5); grid
axis([0 N-1 0 20]);
ylabel('|Y[k]| \rightarrow')
xlabel('n, k \rightarrow')