% Bandpass filtering with DFT
% s3s10_4.m * mw * 11/17/2007
%% Bandpass filter
N = 128;    % DFT length
H = zeros(0,N);
for k=1:N
  wk = (2*pi/N)*(k-1);
  if wk > 3*pi/8 & wk< 5*pi/8 
    H(k) = 1;
  elseif wk > 11*pi/8 & wk< 13*pi/8 
    H(k) = 1;
  else
    H(k) = 0;    
  end
end
% Impulse response
h = real(ifft(H,N));  
% Frequency response
NN = 8*N;
HH = fft(fftshift(h),NN);    % interpolate (zero padding)
% hh = fftshift(h); hh(1)=0; % enforce symmetry
% HH = fft(hh,NN);           % interpolate (zero padding)
%% Graphics
figure('Name','Bandpass Filtering with DFT','NumberTitle','off');
% right sided normalized impulse response (causality)
n = 0:N-1;
h0 = (1/4)*(3.5/4) % maximum of impulse response 2*Omega_cut_off_LP/pi
subplot(4,1,1), stem(n,fftshift(h)/h0,'filled','MarkerSize',5);
axis([0 N-1 -1.1 1.1]); grid;
ylabel('h[n]/h_0 \rightarrow')
xlabel('n \rightarrow')
hold on % sinc envelope depending on bandwidth
B = (1/8)*(3.5/4); % relative normalized (one-sided) bandwidth pi/8
plot(n,sinc((n-N/2)*B),':',n,-sinc((n-N/2)*B),':')
hold off
w = 0:NN-1; w = 2*pi*w/NN; % normalized radian frequency
ww = exp(j*w*N/2); % phase compensation term for time shift
subplot(4,1,2),plot(w/pi,real(HH.*ww)); grid
axis([0 2 -.2 1.2]);
ylabel('Re(H(e^{j\Omega})) \rightarrow')
xlabel('\Omega/\pi \rightarrow')
subplot(4,1,3),plot(w/pi,imag(HH.*ww)); grid
axis([0 2 -.02 .02]);
ylabel('Im(H(e^{j\Omega})) \rightarrow')
xlabel('\Omega/\pi \rightarrow')
subplot(4,1,4),plot(w/pi,-20*log10(abs(HH.*ww))); grid
axis([0 2 0 40]);
ylabel('a(\Omega) in dB \rightarrow')
xlabel('\Omega/\pi \rightarrow')