% Fast convolution using overlap-save method
%s3s10_6.m * mw * 09/26/2007
%% Low-pass design - Fourier method
Omeg_c = 1/5;                   % cut-off radian frequency / pi
n0 = 4/Omeg_c; n = 1:2*n0-1; 
Lh = 2*n0-1;                    % length of impulse response
h = Omeg_c*sinc(Omeg_c*(n-n0)); % impulse response
%% Input signal
Lx = 1e4;           % input signal length
randn('state',0);   % initialize random number generator
x = randn(1,Lx);    % input signal - random sequence
yap = conv(h,x);    % a periodic convolution - for reference

%% Fast convolution using overlap-save method
Nfft = 1024;             % desired fft length
LxB  = Nfft - Lh + 1;    % block length of x for fft
H    = fft(h,Nfft);      % dft spectrum of h of length Nfft
BNr  = 1;                % initialize block number
m   = Nfft - LxB;        % auxiliary index
x = [zeros(1,m) x];      % preceding zeros
y_OS = zeros(size(yap)); % allocate memory for result
while BNr*LxB <= Lx-LxB
    n1 = (BNr-1)*LxB;         % start of block for fft in signal x
    n2 = n1 + Nfft;           % end of block for fft in signal x
    X = fft(x(n1+1:n2),Nfft); % dft spectrum of block
    yB_OS = ifft(H.*X);      % output block
    y_OS(n1+1:n1+LxB) = yB_OS(Nfft-LxB+1:Nfft);
    BNr = BNr + 1;
end
MAX = max(abs(yap(1:floor(Lx/Nfft))-y_OS(1:floor(Lx/Nfft))));
fprintf('maximum deviation = %g \n',MAX)
%% Graphics
FIG1 = figure('Name','Overlap-save Method','NumberTitle','off','Units','normal',...
  'Position',[.5 .4 .45  .55]);
N = 100; n = 0:N; Offset = 1000;
subplot(4,1,1), stem(n,[h/Omeg_c zeros(1,N+1-length(h))],'filled','MarkerSize',5),grid
  axis([0 N -.5 1]); ylabel('h[n] * \pi / \Omega_c \rightarrow')
n = Offset:Offset+N;
subplot(4,1,2), stem(n,x(n+1),'filled','MarkerSize',5),grid
  axis([Offset Offset+N -4 4]); ylabel('x[n] \rightarrow')
subplot(4,1,3), stem(n,yap(n+1),'filled','MarkerSize',5),grid
  axis([Offset Offset+N -2 2]); ylabel('y_{conv}[n] \rightarrow')
subplot(4,1,4), stem(n,y_OS(n+1),'filled','MarkerSize',5),grid
  axis([Offset Offset+N -2 2]);
  xlabel('n \rightarrow'),ylabel('y_{os}[n] \rightarrow')