% Spreading
% s3s11_2.m * mw * 11/17/2007
N = 16;  % simulation time
L = 2;   % spreading factor
n = 0:N-1;
x = cos((2*pi/8)*n);
xs = zeros(1,N*L);
xs(1,1:L:N*L) = x;
% DFT spectra
X  = fft(x);
Xs = fft(xs);
% Graphics
k = 0:N*L-1;
figure('Name','Spreading','NumberTitle','off');
subplot(2,2,1), stem(n,x,'filled','MarkerSize',5); grid
axis([0 N -1 1]);
ylabel('x[n] \rightarrow')
subplot(2,2,2), stem(n,abs(X),'filled','MarkerSize',5); grid
axis([0 N 0 N/2]);
ylabel('|X[k]| \rightarrow')
subplot(2,2,3), stem(k,xs,'filled','MarkerSize',5); grid
axis([0 N*L -1 1]);
ylabel('x_s[n] \rightarrow'); xlabel('n \rightarrow');
subplot(2,2,4), stem(k,abs(Xs),'filled','MarkerSize',5); grid
axis([0 N*L 0 N/2]);
ylabel('|X_s[k]| \rightarrow'); xlabel('k \rightarrow');