% Correlation
% s3s12_2.m * mw * 11/18/2007
N = 400;  % number of samples
x = randn(1,N); % rundom numbers
z = randn(1,N); % random numbers
a = -.8;
b = sqrt(1-a*a);
y = (a*x + b*z)/sqrt(2);
% Empirical correlation coefficient
xmue = sum(x)/N;
sx = sum((x-xmue).^2)/(N-1);
ymue = sum(y)/N;
sy = sum((y-ymue).^2)/(N-1);
rxy = (1/(N-1))*sum((x-xmue).*(y-ymue))/sqrt(sx*sy);
fprintf('\n')
fprintf('nmue: %8.5f     sx: %8.5f\n',xmue,sx)
fprintf('ymue: %8.5f     sy: %8.5f\n',ymue,sy)
fprintf('rxy : %8.5f\n',rxy)
% Graphics
b = rxy*sqrt(sy/sx);
a = ymue - b*xmue;
sigma = ((N-1)/(N-2))*sy*(1-rxy^2);
fprintf('b   : %8.5f     a : %8.5f     sigma: %8.5f\n',b,a,sigma)
figure('Name','Scatter plot','NumberTitle','off');
scatter(x,y,3,'filled')
axis([-3 3 -3 3]); grid
ylabel('y \rightarrow'); xlabel('x \rightarrow');
hold on
n = -3:3;
plot(n,b*n+a,'LineWidth',2)
hold off