% Random numbers and histogram
% s3s12_1.m * mw * 03/20/2008
N = 400;        % number of samples
X = randn(1,N); % random numbers
% Histogram
delta = 1;
Hi = -4:delta:4;
hx = hist(X,Hi);
% Empirical mean and variance
xmue = sum(X)/N;
sx = sum((X-xmue).^2)/(N-1);
fprintf('\n')
fprintf('linear mean: %8.5f\n',xmue)
fprintf('variance   : %8.5f\n',sx)
% Approximating gaussian bell function
x = -4:.1:4;
f = (1/sqrt(2*pi*sx))*exp(-(1/(2*sx))*(x-xmue).^2);
% Graphics
figure('Name','random numbers and histogram','NumberTitle','off');
subplot(2,1,1), plot(1:N,X,'.'), grid
axis([1 N -4 4]);
ylabel('{\itx}_{\iti} \rightarrow'); xlabel('{\iti} \rightarrow');
hx = hx/(N*delta);
subplot(2,1,2), bar(Hi,hx,'y'), grid
ylabel('norm. Histogram, {\itf}_{\itX}({\itx}) \rightarrow'); xlabel('{\itx} \rightarrow');
hold on
plot(x,f,'LineWidth',2)
hold off