% Nonlinear mapping and histogram
% s3s12_3.m * mw * 1/18/2007
N = 1000;  % number of samples
X = randn(1,N); % random numbers
Y = randn(1,N); % random numbers
R = sqrt(X.^2+Y.^2);
% Histogram
delta = .2;
Hi = 0:delta:4;
hr = hist(R,Hi);
% Empirical mean and variance
rmue = sum(R)/N;
sr = sum((R-rmue).^2)/(N-1);
fprintf('\n')
fprintf('linear mean: %8.5f\n',rmue)
fprintf('variance   : %8.5f\n',sr)
% Approximating Rayleigh pdf (sigma = 1)
r = 0:.1:4;
f = r.*exp(-.5*r.^2);
% Graphics
figure('Name','Pdf of Rayleigh distribution','NumberTitle','off');
subplot(2,1,1), plot(1:N,R,'.'), grid
axis([1 N 0 5]);
ylabel('r_i \rightarrow'); xlabel('i \rightarrow');
hr = hr/(N*delta);
subplot(2,1,2), bar(Hi,hr,'y'), grid
ylabel('norm. Histogram, f_R(r) \rightarrow'); xlabel('r \rightarrow');
hold on
plot(r,f,'LineWidth',2)
hold off