% Histogram
% s3s12_4.m * mw * 03/22/2008
T = [5 15 25 35 45 55 65 75 85 95];
h = [0 0 301 1680 3110 3229 1350 210 20 0];
N = sum(h);  % number of samples
hr = h/N;    % relative frequency
% Empirical mean and variance
Nbin = length(T);
Tmue = sum(hr.*T);
Ts = sum(hr.*T.^2)-Tmue^2;
fprintf('\n')
fprintf('linear mean: %8.5f\n',Tmue)
fprintf('variance   : %8.5f\n',Ts)
% Approximating gaussian bell function
x = 0:1:100;
f = (1/sqrt(2*pi*Ts))*exp(-(1/(2*Ts))*(x-Tmue).^2);
% Graphics
bar(T,hr), grid
ylabel('{\ith}_r, 10 * {\itf}_T({\itx}) \rightarrow'); xlabel('{\itx} \rightarrow');
hold on
plot(x,10*f,'r','LineWidth',2)
hold off