% central limit theorem
% s3s13_1.m * mw * 03/25/2008
M = 10;          % number of random variables to be add
N = 10000;       % number of samples per cycle
K = 100;         % number of simulation cycles
delta = .1;      % width of histogram bins 
Hi = -5:delta:5; % bin centers
hx = zeros(size(Hi));
for k =1:K
  X = zeros(1,N);
  for m = 1:M
    Y = (2*rand(1,N)-1)/sqrt(1/3); % normalized uniformally distributed rv
    X = X + Y/sqrt(M);
  end
  hx = hx + hist(X,Hi); % histogram
end
hx = hx/K;
% empirical mean and variance
xmue = sum(X)/N;
sx = sum((X-xmue).^2)/(N-1);
fprintf('\n')
fprintf('linear mean: %8.5f\n',xmue)
fprintf('variance   : %8.5f\n',sx)
% approximating gaussian bell function
x = -5:.1:5; sigma2 = 1; mue = 0;
f = (1/sqrt(2*pi*sigma2))*exp(-(1/(2*sigma2))*(x-mue).^2);
% Graphics
figure('Name',['histogram: M = ',num2str(M)],'NumberTitle','off');
hx = hx/(N*delta);
bar(Hi,hx,'y'), grid
axis([-5 5 0 .5])
ylabel('norm. Histogram, {\itf}_{\itX}({\itx}) \rightarrow'); xlabel('{\itx} \rightarrow');
hold on
plot(x,f,'LineWidth',2)
hold off