% correlation
% s3s13_10.m * mw * 03/25/2008
N = 401;  % number of samples
n = 0:N-1;
x1 = randn(1,N);
x2 = randn(1,N);
x3 = randn(1,N);
% impulse response
h = triang(33);
y1 = conv(x1,h); y1 = .5*y1(20:length(n)+19);
y2 = conv(x2,h); y2 = .5*y2(20:length(n)+19);
y3 = conv(x3,h); y3 = .5*y3(20:length(n)+19);
% graphics
figure('Name','Correlation','NumberTitle','off');
subplot(3,2,1), plot(n,x1,'.'),grid
axis([0 400 -5 5]);
ylabel('x_1[n] \rightarrow');
subplot(3,2,3), plot(n,x2,'.'),grid
axis([0 400 -5 5]);
ylabel('x_2[n] \rightarrow');
subplot(3,2,5), plot(n,x3,'.'),grid
axis([0 400 -5 5]);
ylabel('x_3[n] \rightarrow'); xlabel('n \rightarrow');
subplot(3,2,2), plot(n,y1,'.'),grid
axis([0 400 -5 5]);
ylabel('y_1[n] \rightarrow');
subplot(3,2,4), plot(n,y2,'.'),grid
axis([0 400 -5 5]);
ylabel('y_2[n] \rightarrow');
subplot(3,2,6), plot(n,y3,'.'),grid
axis([0 400 -5 5]);
ylabel('y_3[n] \rightarrow'); xlabel('n \rightarrow');
% end