% correlation and white process
% s3s13_12.m * mw * 03/25/2008
N = 1000;  % number of samples
X1 = (randn(1,N)+j*randn(1,N));
x1 = real(fft(X1)/sqrt(N));
X2 = sqrt(2)*X1;
X2(401:600) = zeros(1,200); % low pass
x2 = real(fft(X2)/sqrt(N));
% predictor (feedback)
x3 = zeros(1,N); x3(1) = x2(1);
for k = 2:length(x2)
  x3(k) = x2(k) + 0.9*x3(k-1);
end
x3 = x3/2;
% predictor (forward)
x4 = zeros(1,N);
for k = 2:length(x2)
  x4(k) = x3(k) - 0.9*x3(k-1);
end
x4 = 2*x4;
% graphics
n = 0:100;
figure('Name','Correlation','NumberTitle','off');
subplot(4,1,1), stem(n,x1(1:101),'.'),grid
axis([0 100 -4 4]);
ylabel('x_1[n] \rightarrow');
subplot(4,1,2), stem(n,x2(1:101),'.'),grid
axis([0 100 -4 4]);
ylabel('x_2[n] \rightarrow');
subplot(4,1,3), stem(n,x3(1:101),'.'),grid
axis([0 100 -4 4]);
ylabel('x_3[n] \rightarrow'); xlabel('n \rightarrow');
subplot(4,1,4), stem(n,x4(1:101),'.'),grid
axis([0 100 -4 4]);
ylabel('x_4[n] \rightarrow'); xlabel('n \rightarrow');
% end