% Time auto-correlation, 2nd order system
% s3s13_2.m * mw * 03/25/2008
K = 21;              % length of estimated correlation sequence
N = 100000;          % length of random sequence
x = randn(1,N+K);    % normally distributed, white input sequence
a = [1 -0.71 +0.25]; % denominator
b = [0 1 0];         % numerator
y = filter(b,a,x);   % 2nd order system
% correlation
R = zeros(1,K);
for k =1:K
 Ryy(k) = sum(y(1:N).*y(k:N+k-1))/N;  % acf estimator
end
fprintf('acf : Ryy[0] = %g\n',Ryy(1)) % mean power
% approximating time acf (theory)
p = roots(a);
r = abs(p(1));
Omega = angle(p(1));
B = (1/(p(1)-p(2)))*(1/(1/p(1)+a(2)+a(3)*p(1)));
l = 0:K-1;
RYY = 2*r.^l.*(real(B)*cos(Omega*l)-imag(B)*sin(Omega*l));
% graphics
figure('Name','auto-correlation function','NumberTitle','off');
stem(l,Ryy,'full'), grid
axis([0 K-1 -.2 1.6])
ylabel('acf, {\itR}_{{\ityy}}[{\itl}] \rightarrow'); xlabel('{\itl} \rightarrow');
hold on
plot(l,RYY,':','LineWidth',2)
hold off
% end