% 1st order prediction, 2nd order system
% s3s13_3.m * mw * 03/25/2008
K = 11;              % length of estimated correlation sequence
N = 100000;          % length of random sequence
x = randn(1,N+K);    % normally distributed, white input sequence
a = [1 -0.71 +0.25]; % denominator
b = [0 1 0];         % numerator
y = filter(b,a,x);   % 2nd order system
% analytical time acf
p = roots(a);
r = abs(p(1));
Omega = angle(p(1));
B = (1/(p(1)-p(2)))*(1/(1/p(1)+a(2)+a(3)*p(1)));
l = -K:1:K;
RYY = 2*r.^abs(l).*(real(B)*cos(Omega*abs(l))-imag(B)*sin(Omega*abs(l)));
% 1st order linear prediction
u = y(2:length(y)) - RYY(K+2)/RYY(K+1)*y(1:length(y)-1);
% correlation (two-sided)
Ruu = (1/N)*xcorr(u,K); 
fprintf('acf : Ruu[0] = %g\n',Ruu(K+1)) % mean power
stem(l,Ruu,'full'), grid
axis([-K+1 K-1 -.4 1.6])
ylabel('acf, {\itR}_{{\ituu}}[{\itl}] \rightarrow'); 
xlabel('{\itl} \rightarrow');
hold on  
plot(l,RYY,':','LineWidth',2)
hold off