% time auto-correlation function of chirp signals
% chirp_gauss.m * mw * 03/25/08 
% chirp signal
N  = 200;                   % half length of chirp signal, Tc = 2*N/fs
fs = 20e3;                  % sampling frequency, 20 kHz
f0 = 4e3;                   % center frequency, 2 kHz
sf = 2;                     % scaling factor
mue = (sf*f0/fs)*(1/(2*N)); % normalized chip rate
T = N/sqrt(2);              % normalized chirp "duration" 
n = -N:N;                   % normalized time
gauss = exp(-(1/T)^2*n.^2);         % gaussian envelope
phi = 2*pi*(f0/fs)*n + pi*mue*n.^2; % phase term
chirp = cos(phi).*gauss;            % chirp signal
soundsc(chirp,fs);                  % audio output
Rcc = conv(fliplr(chirp),chirp);    % matched filter receiver
% Graphics
FIG1 = figure('Name','chirp signal','NumberTitle','off',...
  'Units','normal','Position',[.4 .3 .55  .65]);
t = n/fs;
subplot(2,1,1), plot(t*1e3,chirp), grid
axis([-1e3*N/fs 1e3*N/fs -1 1]);
xlabel('{\itt} / ms \rightarrow'), ylabel('{\itc}({\itt}) \rightarrow')
% title('chirp signal')
n = -2*N:2*N;
t = n/fs;
subplot(2,1,2),plot(t*1e3,Rcc/max(Rcc)), grid
axis([-1e3*N/fs 1e3*N/fs -1.2 1.2]);
xlabel('{\itt} / ms \rightarrow') 
ylabel('norm. {\itR}_{{\itcc}}({\itt}) \rightarrow') 
% title('time auto-correlation function')
FIG2 = figure('Name','chirp signal : spectrum','NumberTitle','off',...
  'Units','normal','Position',[.4 .3 .55  .65]);
Chirp = abs(fft(chirp)); Chirp = Chirp/max(Chirp);
w = 0:2*N;
f = fs*w/(2*N+1);
subplot(2,1,1),plot(1e-3*f(1:2:N+1),Chirp(1:2:N+1),'.'), grid
axis([0 1e-3*fs/2 0 1]);
xlabel('{\itf} / kHz \rightarrow')
ylabel('norm. |{\itC}({\itf})| \rightarrow')
% gaussian bell function
alpha = fs*(2*sqrt(2)/N)*sqrt(1 + pi^2*(sf*f0/fs)^2*(N/4)^2);
alpha = alpha/(2*pi); % corner frequency (theoretical)
gauss = exp(-((f-f0).^2)/alpha^2);
hold on
plot(1e-3*f(1:N+1),gauss(1:N+1)/max(gauss))
hold off
% title('spectrum')
subplot(2,1,2),plot(1e-3*f(1:2:N+1),20*log10(max(Chirp(1:2:N+1),1e-6)),'.'), grid
axis([0 1e-3*fs/2 -60 1]);
xlabel('{\itf} / kHz \rightarrow')
ylabel('norm. |{\itC}({\itf})| in dB \rightarrow')
hold on
plot(1e-3*f(1:N+1),20*log10(max(gauss(1:N+1)/max(gauss),1e-6)))
hold off
% spectrogram
FIG3 = figure('Name','chirp signal : spectrogram','NumberTitle','off',...
  'Units','normal','Position',[.4 .3 .55  .65]);
M = 32;
specgram(chirp,M,fs*1e-3,gausswin(M),M/2), grid
title('spectrogram of chirp signal')
ylabel('{\itf} / kHz \rightarrow')
xlabel('{\itt} / ms \rightarrow')