% state space variable
% ssv.m * mw * 03/25/2008
NSC = 31; % Number of simulation cycles
% Transposed direct form II
A2 = [1.6 1; -.8 0];  b2 = [1.6; .36];   c2T = [1 0];    d2 = 1;
s2 = zeros(2,NSC); % state space variables
y2 = zeros(1,NSC); % output signal
% Normal form
AN = [.8 .4; -.4 .8]; bN = [1.64; -.64]; cNT = [0 -2.5]; dN = 1;
sN = zeros(2,NSC); % state space variables
yN = zeros(1,NSC); % output signal
% Simulation of impulse response
x = [1 zeros(1, NSC-1)]; % impulse
for n = 1:NSC-1
    s2(:,n+1) = A2*s2(:,n)  + b2*x(n);   % Transposed direct form II
    y2(n)     = c2T*s2(:,n) + d2*x(n);
    sN(:,n+1) = AN*sN(:,n)  + bN*x(n);    % Normal form
    yN(n)     = cNT*sN(:,n) + dN*x(n);
end
% Graphics
FIG = figure('Name','Impulse response and state space variables','NumberTitle','off');
% Impulse response
n = 0:NSC-1;
subplot(2,2,1), stem(n,y2,'full')
axis([0 NSC -2 4]); grid;
xlabel('{\itn} \rightarrow'), ylabel('{\ith}[{\itn}] \rightarrow')
title('Transposed direct form II')
subplot(2,2,3), stem(n,yN,'full')
axis([0 NSC -2 4]); grid;
xlabel('{\itn} \rightarrow'), ylabel('{\ith}[{\itn}] \rightarrow')
title('Normal form')
% State space variables 
s2 = s2(:,1:15); sN = sN(:,1:15);
subplot(2,2,2), plot(s2(1,:),s2(2,:),':',s2(1,:),s2(2,:),'o')
axis([-4 4 -4 4]); grid
xlabel('{\its}_1[{\itn}] \rightarrow')
ylabel('{\its}_2[{\itn}] \rightarrow')
subplot(2,2,4), plot(sN(1,:),sN(2,:),':',sN(1,:),sN(2,:),'o')
axis([-2 2 -2 2]); grid
xlabel('{\its}_1[{\itn}] \rightarrow')
ylabel('{\its}_2[{\itn}] \rightarrow')