% Moving average filter
% s3s2_1.m * mw * 07/17/2007
%% Initialize parameters and generate signals
N = 50;                % normalized time span
n = 0:N;               % normalized time
Omega = 2*pi/50;       % normalized radian frequency
v = sin(Omega*n);      % signal
r = 0.2*randn(1,N+1);  % noise signal
x = v + r;             % noisy signal
%% Moving average filter
M = 9;                 % window length
shift = fix(M/2);      % time shift for causality
y = zeros(1,N+1);      % output signal
for k=1:N-M+1
    y(k+shift) = (1/M)*sum(x(k:k+M-1));
end
%% Graphics
figure('Name',['Moving average: M = ',num2str(M)],'NumberTitle','off');
subplot(3,1,1) % signal
    stem(n,v,'filled')
    axis([0 N -2 2]); ylabel('v[n] \rightarrow'); grid
subplot(3,1,2) % noisy signal
    stem(n,x,'filled')
    axis([0 N -2 2]); ylabel('x[n] \rightarrow'); grid
    hold on; plot(n,v,':k'); hold off
subplot(3,1,3) % restored signal
    stem(n,y,'filled')
    axis([0 N -2 2]); grid
    xlabel('n \rightarrow')
    ylabel('y[n] \rightarrow')
    hold on; plot(n,v,':k'); hold off