% Median filter
% s3s2_2.m * mw * 07/17/2007
%% Initialize parameters and generate signals
N = 50;                 % normalized time span
n = 0:N;                % normalized time
v = zeros(1,N+1);       % signal
v(11:21) = ones(1,11);  % rectangular impulse     
r = zeros(1,N+1);       % impulse noise signal
loc = 1 + fix(50*rand(1,5));  % impulse locations
r(loc) = ones(1,5);
x = v + r;              % noisy signal
%% Moving median
M = 5;                  % window length
shift = fix(M/2);       % time shift for causality
y = zeros(1,N+1);       % output signal
for k=1:N-M+1
    y(k+shift) = median(x(k:k+M-1));
end
%% Graphics
figure('Name',['moving median: M = ',num2str(M)],'NumberTitle','off');
subplot(3,1,1) % signal
    stem(n,v,'filled')
    axis([0 N -2 2]); ylabel('v[n] \rightarrow'); grid;
subplot(3,1,2) % noisy signal
    stem(n,x,'filled')
    axis([0 N -2 2]); ylabel('x[n] \rightarrow'); grid;
    hold on
    plot(n,v,':k')
subplot(3,1,3) % restored signal
    stem(n,y,'filled')
    axis([0 N -2 2]); grid
    xlabel('n \rightarrow'); ylabel('y[n] \rightarrow');
    hold on
    plot(n,v,':k')