function s3s2_3
% Solving differential equation for RC circuit
% s3s2_3.m * mw * 07/17/2007
%% Initialization
tspan = [0 8]; % time span for evaluation
y0 = 0;        % initial condition
options = odeset('refine',10);
[t,y] = ode45(@rc,tspan,y0,options);
%% Graphics
figure('Name','RC circuit wit rectangular input impulse','NumberTitle','off');
plot(t,y,'LineWidth',2), grid
axis([0 8 0 0.8]);
xlabel('t in s \rightarrow'); ylabel('u_C(t) in V \rightarrow')
%% Subfunction
% first-order ordinary differential equation (ODE)for RC circuit
function dydt = rc(t,y);
% input signal: rectangular impulse
if t > .3 & t < 1.3
    x = 1;
else
    x = 0;
end
dydt = 1*(x - y);   % ODE