% Moving average with FIR system using convolution
% s3s3_1.m * mw * 07/23/2007
%% Initialize parameters and generate signals
N = 50;                 % normalized time span
n = 0:N;                % normalized time
Omega = 2*pi/50;        % normalized radian frequency of signal
v = sin(Omega*n);       % signal
r = 0.2*randn(1,N+1);   % noise signal
x = v + r;              % noisy signal
%% Moving average
M = 9;                  % window length
h = (1/M)*ones(1,M);    % finite-length impulse response (FIR)
y = conv(h,x);          % output signal
%% Graphics
figure('Name',['FIR system : Moving average with M = ',num2str(M)],'NumberTitle','off');
subplot(3,1,1); stem(n,v,'filled') % signal
    axis([0 N -2 2]); ylabel('v[n] \rightarrow'); grid
subplot(3,1,2); stem(n,x,'filled') % noisy signal
    axis([0 N -2 2]); ylabel('x[n] \rightarrow'); grid
    hold on; plot(n,v,':k'); hold off
subplot(3,1,3); stem(0:length(y)-1,y,'filled') % restored signal
    axis([0 N+M-1 -2 2]); grid
    xlabel('n \rightarrow'); ylabel('y[n] \rightarrow')
    shift = fix(M/2); % time shift for signal alignment
    hold on; plot(n+shift,v,':k'); hold off