% Barker code and matched filter receiver
% s3s3_2.m * mw * 07/23/2007
%% Barker code length 11 and matched filter impulse response b[11-n]
b = [1,1,1,-1,-1,-1,1,-1,-1,1,-1];
h = fliplr(b);
%% Matched filtering
y = conv(h,b); % output signal
%% Graphics
figure('Name',['Barker code with length N = ',num2str(length(b))],'NumberTitle','off');
subplot(1,3,1); stem(0:length(b)-1,b,'filled'); grid% Barker code
    axis([0,length(b)-1,-2,2]); xlabel('n \rightarrow'); ylabel('b[n] \rightarrow')
subplot(1,3,2); stem(0:length(b)-1,h,'filled'); grid % matched-filter impulse response
    axis([0,length(b)-1,-2,2]); xlabel('n \rightarrow'); ylabel('h[n] \rightarrow')
subplot(1,3,3); stem(0:length(y)-1,y,'filled'); grid % matched filter output signal
    axis([0,length(y)-1,-2,12])
    xlabel('n \rightarrow'); ylabel('y[n] \rightarrow')