% Barker code and matched filter receiver
% s3s3_3.m * mw * 07/23/2007
%% Barker code length 11 and matched filter impulse response b[11-n]
b = [1,1,1,-1,-1,-1,1,-1,-1,1,-1];   
h = fliplr(b);
x = b + 1*randn(1,length(b)); 	% noisy signal
%% Matched filter
y = conv(h,x); 	% output signal
%% Graphics
figure('Name',['Barker code with length N = ',num2str(length(b))],'NumberTitle','off');
% matched-filter impulse response 
subplot(1,2,1); stem(0:length(x)-1,x,'filled'); grid 
    axis([0,length(x)-1,-5,5]); xlabel('n \rightarrow'); ylabel('x[n],b[n] \rightarrow')
    hold on; stem(0:length(b)-1,b); hold off
% matched filter output signal 
subplot(1,2,2); stem(0:length(y)-1,y,'filled'); grid 
    axis([0,length(y)-1,-5,20])
    xlabel('n \rightarrow'); ylabel('y[n] / max|y[n]| \rightarrow')
