% System with 1. order DEQ
% s3s3_4.m * mw * 07/23/2007
%% Initialize system and generate input signals
a = -0.8;
N = 20;
delta = [1 zeros(1,N)]; % unit impulse function
u = ones(1,N+1);        % unit step function
%% Simulation
h = length(delta); h(1) = delta(1);
for n = 2:N+1
    h(n) = delta(n) - a*h(n-1); % impulse response
end
s = length(u); s(1) = u(1);
for n = 2:N+1
    s(n) = u(n) - a*s(n-1); % step response
end
%% Graphics
figure('Name',['1st order system with a = ',num2str(a)],'NumberTitle','off');
 subplot(1,2,1); stem(0:length(h)-1,h,'filled'); grid % impulse response
    axis([0,length(h)-1,0,5]); xlabel('n \rightarrow'); ylabel('h[n] \rightarrow')
subplot(1,2,2); stem(0:length(s)-1,s,'filled'); grid % step response
    axis([0,length(s)-1,0,5])
    xlabel('n \rightarrow'); ylabel('s[n] \rightarrow')