% System with 1st order DEQ with sinusoidal input
% s3s3_5.m * mw * 07/23/2007
%% Initialize system and generate input signals
a = -0.8;
n = 0:40;
w = pi/8; 
x = cos(w*n); % cosine function
%% Simulation
y = length(x); y(1) = x(1);
for n = 2:N+1
    y(n) = x(n) - a*y(n-1); % DEQ
end
%% Graphics
figure('Name',['1st order system with a = ',num2str(a)],'NumberTitle','off');
subplot(2,1,1); stem(0:length(x)-1,x,'filled'); grid % input signal
    axis([0,length(x)-1,-3,3]); xlabel('n \rightarrow'); ylabel('x[n] \rightarrow')
subplot(2,1,2); stem(0:length(y)-1,y,'filled'); grid % output signal
    axis([0,length(y)-1,-3,3])
    xlabel('n \rightarrow'); ylabel('y[n] \rightarrow')