% Simulation of 2nd order System
% S3S4_1.m * mw * 07/30/2007
%% Initialization
a = [1 1.4 .49]; b = [0 .2 .4];  % numerator and denominator coefficients
N = 40; n = 0:N;                 % normalized time
%% Filtering
x = [1 zeros(1,N)]; % impulse function
y = zeros(size(x)); % allocate memory for output signal
s = zeros(1,2);     % initialize state variables   
for k=1:length(x)
    y(k) = b(1)*x(k)            + s(1);
    s(1) = b(2)*x(k) -a(2)*y(k) + s(2);
    s(2) = b(3)*x(k) -a(3)*y(k);
end
% y = filter(b,a,x);% Matlab built-in function
h = y;              % impulse response
x = ones(1,N+1);    % step function
y = zeros(size(x)); % allocate memory for output signal
s = zeros(1,2);     % initialize state variables   
for k=1:length(x)
    y(k) = b(1)*x(k)            + s(1);
    s(1) = b(2)*x(k) -a(2)*y(k) + s(2);
    s(2) = b(3)*x(k) -a(3)*y(k);
end
% y = filter(b,a,x); % Matlab built-in function
s = y;
%% Graphics
FIG1 = figure('Name','S3S4_1 : 1st order DGL with harmonic input signal','NumberTitle','off');
subplot(2,1,1),stem(n,h,'filled'), grid
    xlabel('n \rightarrow'), ylabel('h[n] \rightarrow')
    title('Impulse response')
subplot(2,1,2),stem(n,s,'filled'), grid
    xlabel('n \rightarrow'), ylabel('s[n] \rightarrow')
    title('Step response')