% 1st order DGL
% S3S4_2.m * mw * 07/26/2007
%% Initialization
a1 = -0.8; q = 0.5; % simulation parameters
n = 0:20;           % normalized time
%% Impulse response
d = zeros(size(n)); d(1) = 1;
h = zeros(size(d));
h(1) = d(1);
for k=2:length(n)
    h(k) = d(k) - a1*h(k-1); 
end
%% Step response
u = ones(size(n));
s = zeros(size(u));
s(1) = u(1);
for k=2:length(n)
    s(k) = u(k) - a1*s(k-1); 
end
%% Exponential input signal
x = q.^n;
y = zeros(size(x));
y(1) = x(1);
for k=2:length(n)
    y(k) = x(k) - a1*y(k-1); 
end
%% Graphics
FIG1 = figure('Name','S3S4_2 : 1st order DGL','NumberTitle','off');
subplot(3,2,1), stem(n,d,'filled'), grid
xlabel('n \rightarrow'), ylabel('\delta[n] \rightarrow')
title('Impulse function')
subplot(3,2,2), stem(n,h,'filled'), grid
xlabel('n \rightarrow'), ylabel('h[n] \rightarrow')
title('Impulse response')
subplot(3,2,3), stem(n,u,'filled'), grid
xlabel('n \rightarrow'), ylabel('u[n] \rightarrow')
title('Step function')
subplot(3,2,4), stem(n,s,'filled'), grid
xlabel('n \rightarrow'), ylabel('s[n] \rightarrow')
title('Step response')
subplot(3,2,5), stem(n,x,'filled'), grid
xlabel('n \rightarrow'), ylabel('x[n] \rightarrow')
title('Exponential input signal')
subplot(3,2,6), stem(n,y,'filled'), grid
xlabel('n \rightarrow'), ylabel('y[n] \rightarrow')
title('Output signal')