% 1st order DGL with harmonic input
% S3S4_3.m * mw * 07/26/2007
%% Initialization and filtering
a1 = -0.8; w = pi/8; % simulation parameters
n = 0:40;            % normalized time
x = cos(w*n);        % harmonic input signal
y = zeros(size(x));
y(1) = x(1);
for k=2:length(n)
    y(k) = x(k) - a1*y(k-1); 
end
%% Graphics
FIG1 = figure('Name','S3S4_3 : 1st order DGL with harmonic input signal','NumberTitle','off');
stem(n,y,'filled'), grid
    xlabel('n \rightarrow'), ylabel('y[n] \rightarrow')
    title('Output signal')
% transient and stationary part
yt = real(a1/(1-exp(j*w)))*(-a1).^n;
ys = real((exp(j*w)/(exp(j*w)+a1))*exp(j*w*n));
hold on
plot(n,yt,':r','LineWidth',2)
plot(n,ys,'--k','LineWidth',2)
hold off