% 2nd order DGL - impulse or step response
%  analytical solution and simulation 
%  based on S3S4_4 - not specialized
% S3S4_5.m * mw * 07/26/2007
%% system coefficients, characteristic polynomial
CASE_Sys = input('Case 1,2 or 3 : ');
switch CASE_Sys
    case 1
        a = [1 -1 0.2];     % two distinct real poles
    case 2
        a = [1 -1.4 .49];   % repeated pole
    case 3
        a = [1 -1.6 0.8];   % conjugate complex pair of poles
    otherwise
        error('incorrect case selection')
end
b = [1 0 0];    % zeroes
CASE_zq = input('Impulse or step response  0 or 1 : ');
switch CASE_zq
    case 0
        zq = 0; % for impulse response
    case 1
        zq = 1; % for step response
    otherwise
        error('incorrect signal selection')
end
n = 0:40;       % normalized time
p = roots(a);   % pair of poles
d = [-a(2); -a(2)*(zq-a(2))-a(3)];
if CASE_Sys~=2   % distinct poles
    A = [p(1)-zq p(2)-zq; p(1)^2-zq^2 p(2)^2-zq^2];
    C = A\d;  % solve system of linear equations
    yh = C(1)*p(1).^n + C(2)*p(2).^n; % homogeneous response
    c = 1 - C(1) - C(2);
    yp = c*zq.^n; % particular response
else % repeated pole
    A = [p(1)-zq p(2); p(1)^2-zq^2 2*p(2)^2 ];
    C = A\d;  % solve system of linear equations
    yh = C(1)*p(1).^n + C(2)*n.*p(2).^n; % homogeneous response
    c  = 1 - C(1);
    yp = c*zq.^n; % particular response
end
fprintf('C1 = %g  %+gj \n',real(C(1)),imag(C(1)))
fprintf('C2 = %g  %+gj \n',real(C(2)),imag(C(2)))
fprintf('c  = %g  %+gj \n\n',real(c),imag(c))
%% Graphics
FIG1 = figure('Name','S3S4_5 : Zero-pole plot','NumberTitle','off');
zplane(b,a), grid
FIG2 = figure('Name','S3S4_5 : 2nd order DGL','NumberTitle','off');
subplot(3,1,1), stem(n,yh,'filled'), grid
    xlabel('n \rightarrow'), ylabel('y_h[n] \rightarrow')
    title('Homogeneous response')
subplot(3,1,2), stem(n,yp,'filled'), grid
    xlabel('n \rightarrow'), ylabel('y_p[n] \rightarrow')
    title('Particular response')
subplot(3,1,3), stem(n,yh+yp,'filled'), grid
    xlabel('n \rightarrow'), ylabel('y[n] \rightarrow')
    title('System response')
%% Simulation
x = zq.^n;         % input signal
y = filter(b,a,x); % filtering
max_error = max(abs(y-(yp+yh))); % maximum error
fprintf('Error  max|y-(yp+yh)| = %g \n\n',max_error)
%% Graphics
FIG3 = figure('Name','S3S4_5 : 2nd order DGL','NumberTitle','off');
subplot(2,1,1), stem(n,x,'filled'), grid
    xlabel('n \rightarrow'), ylabel('x[n] \rightarrow')
    title('Input signal')
subplot(2,1,2), stem(n,y,'filled'), grid
    xlabel('n \rightarrow'), ylabel('y[n] \rightarrow')
    title('System response')