% 2nd order DGL - impulse or step response
%  analytical solution (specilized) and simulation result
% S3S4_6.m * mw * 07/26/2007
%% system coefficients, characteristic polynomial
n = 0:40;       % normalized time
CASE_Sys = input('Case 1,2 or 3 : ');
switch CASE_Sys
    case 1
        a = [1 -1 0.2];                   % two distinct real poles
        p = roots(a);                     % pair of poles
        D1 = (-a(2)-p(2))/(p(1)-p(2));
        ha = D1*p(1).^n + (1-D1)*p(2).^n; % impulse response
        fprintf('D1 = %g  %+gj \n',real(D1),imag(D1))
    case 2
        a = [1 -1.4 .49];    % repeated pole
        p = roots(a);        % pair of poles
        ha = (1+n).*p(1).^n; % impulse response
    case 3
        a = [1 -1.6 0.8];    % conjugate complex pair of poles
        p = roots(a);        % pair of poles
        D1 = (1/2)*(1-j*cot(angle(p(1))));
        ha = 2*real(D1*p(1).^n); % impulse response
        fprintf('D1 = %g  %+gj \n',real(D1),imag(D1))
    otherwise
        error('incorrect case selection')
end
%% Simulation
b = [1 0 0];         % zeroes
x = [1 zeros(1,40)]; % inpuls
y = filter(b,a,x);   % filtering
max_error = max(abs(y-ha)); % maximum error
fprintf('Error  max|y-ha| = %g \n\n',max_error)
%% Graphics
FIG1 = figure('Name','S3S4_6 : Zero-pole plot','NumberTitle','off');
zplane(b,a), grid
FIG2 = figure('Name','S3S4_6 : Impulse response of 2nd order DGL','NumberTitle','off');
subplot(2,1,1), stem(n,ha,'filled'), grid
    xlabel('n \rightarrow'), ylabel('h_a[n] \rightarrow')
    title('Impulse response (analytical)')
subplot(2,1,2), stem(n,y,'filled'), grid
    xlabel('n \rightarrow'), ylabel('h_s[n] \rightarrow')
    title('Impulse response (simulated)')