% 1st order DGL - compound interest formula
% S3S4_7.m * mw * 07/30/2007
%% Initialization
p = 0.04 % interest
A = 20;  % term
n = 0:A; % normalized time
b = [0 (1+p)]; a = [1 -(1+p)]; % numerator; denominator
%% Simulation - regular deposit
x1 = [ones(1,A) 0];
y1 = filter(b,a,x1);
fprintf('Capital = %g \n\n',y1(end));
%% Simulation - irregular deposit
x2 = [ones(1,A) 0]; x2(6:7) = zeros(1,2); x2(8:12) = .5*ones(1,5);
y2 = filter(b,a,x2);
fprintf('Capital = %g \n\n',y2(end))
%% Graphics
FIG1 = figure('Name','S3S4_7 : Compound interest formula - statement of account','NumberTitle','off');
stem(n,y1,'filled'), grid
    xlabel('n \rightarrow'), ylabel('C_n \rightarrow')
    title('Balance')
hold on, stem(n,y2,'MarkerSize',8), hold off