function s3s5_1
% differential equation for RC circuit
% s3s5_1.m * mw * 9/02/2007
tspan = [0 6];  % time span for evaluation
y0 = 1;         % initial condition
options = odeset('refine',10);
[t,x] = ode45(@rc,tspan,y0,options);
% graphics
figure('Name','RC circuit','NumberTitle','off');
plot(t,real(x)), grid
axis([0 6 -2 2]);
xlabel('{\itt} in s \rightarrow'); ylabel('{\itu_C}({\itt}) in V \rightarrow')
% subfunction
function dydt = rc(t,y);
x = 8*exp(j*2*pi*t); % input signal = cosine sequence 
dydt = x - y;        % 1st order ODE