function s3s5_2
% differential equation for RLC circuit
% s3s5_2.m * mw * 9/02/2007
tspan = [0 20];  % time span for evaluation
x0 = [0;1];      % initial condition x1 and x2
options = odeset('refine',10);
[t,x] = ode45(@rlc,tspan,x0,options);
% graphics
figure('Name','RLC circuit','NumberTitle','off');
plot(t,x(:,1)), grid
axis([0 20 -.4 .8]);
xlabel('{\itt} in s \rightarrow'); ylabel('{\iti}({\itt}) in A \rightarrow')
% subfunction
function dxdt = rlc(t,x);
dxdt = [x(2); -.5*x(2)-x(1)]; % 2nd order ODE